from typing import List, Dict

from auxiliary import AuxiliaryStruct
from dbAPI import dbAPI
from templates import Insegnamento
from log import logger

from patterns import *



class InsegnamentoHandler(metaclass=SingletonMeta):
    '''Carica tutti gli insegnamenti partendo dal db.
    
    Params:
        aux (AuxiliaryStruct): classe gestore delle risorse ausiliarie per il modelllo
        dbAPI (dbAPI): classe con le API per leggere il db'''
    def __init__(self):
        self.AUX:AuxiliaryStruct = AuxiliaryStruct()
        self.dbAPI:dbAPI = dbAPI()
        self.endLoaded:bool = False
        self.log:logger = logger
    
    def loadInsegnamenti(self):
        '''Carica la lista di Insegnamenti dal db'''
        if self.endLoaded:
            self.log.info_log("InsegnamentoHandler.loadInsegnamenti(): caricamento già concluso")
            return
        self.AUX.createList_Insegnamenti()
        listIns = self.dbAPI.get_Insegnamenti()
        
        for row in listIns:
            ins = Insegnamento(str(row[0]), int(row[1]), int(row[2]), row[3], row[4], row[5], int(row[6]), row[7])
            self.AUX.add_InsegnamentoToList(ins)      
        
        self.AUX.endList_Insegnamenti()
        self.endLoaded = True

        

            
